/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database;

import com.mckoi.database.DataCellCache;
import com.mckoi.database.DataTableColumnDef;
import com.mckoi.database.DataTableDef;
import com.mckoi.database.DataTableListener;
import com.mckoi.database.DatabaseQueryContext;
import com.mckoi.database.DefaultDataTable;
import com.mckoi.database.Expression;
import com.mckoi.database.GroupResolver;
import com.mckoi.database.QueryContext;
import com.mckoi.database.RowEnumeration;
import com.mckoi.database.SimpleRowEnumeration;
import com.mckoi.database.SubsetColumnTable;
import com.mckoi.database.TObject;
import com.mckoi.database.TType;
import com.mckoi.database.Table;
import com.mckoi.database.TableName;
import com.mckoi.database.Variable;
import com.mckoi.database.VariableResolver;
import com.mckoi.database.VirtualTable;
import com.mckoi.util.BigNumber;
import com.mckoi.util.IntegerVector;

public class FunctionTable
extends DefaultDataTable {
    private static int UNIQUE_KEY_SEQ = 0;
    private static final TableName FUNCTION_TABLE_NAME = new TableName(null, "FUNCTIONTABLE");
    private int unique_id;
    private DataTableDef fun_table_def;
    private Table cross_ref_table;
    private Table.TableVariableResolver cr_resolver;
    private TableGroupResolver group_resolver;
    private Expression[] exp_list;
    private byte[] exp_info;
    private IntegerVector group_lookup;
    private IntegerVector group_links;
    private boolean whole_table_as_group = false;
    private IntegerVector whole_table_group;
    private int whole_table_group_size;
    private boolean whole_table_is_simple_enum;
    private QueryContext context;
    static /* synthetic */ Class class$com$mckoi$database$FunctionTable;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FunctionTable(Table cross_ref_table, Expression[] in_exp_list, String[] col_names, DatabaseQueryContext context) {
        super(context.getDatabase());
        Class clazz = class$com$mckoi$database$FunctionTable == null ? (class$com$mckoi$database$FunctionTable = FunctionTable.class$("com.mckoi.database.FunctionTable")) : class$com$mckoi$database$FunctionTable;
        synchronized (clazz) {
            this.unique_id = UNIQUE_KEY_SEQ++;
        }
        this.unique_id = this.unique_id & 0xFFFFFFF | 0x10000000;
        this.context = context;
        this.cross_ref_table = cross_ref_table;
        this.cr_resolver = cross_ref_table.getVariableResolver();
        this.cr_resolver.setRow(0);
        this.fun_table_def = new DataTableDef();
        this.fun_table_def.setTableName(FUNCTION_TABLE_NAME);
        this.exp_list = new Expression[in_exp_list.length];
        this.exp_info = new byte[in_exp_list.length];
        for (int i = 0; i < in_exp_list.length; ++i) {
            Expression expr = in_exp_list[i];
            if (expr.isConstant() && !expr.hasAggregateFunction(context)) {
                TObject result = expr.evaluate(null, null, context);
                this.exp_list[i] = expr = new Expression(result);
                this.exp_info[i] = 1;
            } else {
                this.exp_list[i] = expr;
                this.exp_info[i] = 0;
            }
            DataTableColumnDef column = new DataTableColumnDef();
            column.setName(col_names[i]);
            column.setFromTType(expr.returnTType(this.cr_resolver, context));
            this.fun_table_def.addVirtualColumn(column);
        }
        this.fun_table_def.setImmutable();
        this.row_count = cross_ref_table.getRowCount();
        this.blankSelectableSchemes(1);
    }

    public FunctionTable(Expression[] exp_list, String[] col_names, DatabaseQueryContext context) {
        this(context.getDatabase().getSingleRowTable(), exp_list, col_names, context);
    }

    private TObject calcValue(int column, int row, DataCellCache cache) {
        this.cr_resolver.setRow(row);
        if (this.group_resolver != null) {
            this.group_resolver.setUpGroupForRow(row);
        }
        Expression expr = this.exp_list[column];
        TObject cell = expr.evaluate(this.group_resolver, this.cr_resolver, this.context);
        if (cache != null) {
            cache.put(this.unique_id, row, column, cell);
        }
        return cell;
    }

    public void setWholeTableAsGroup() {
        this.whole_table_as_group = true;
        this.whole_table_group_size = this.getReferenceTable().getRowCount();
        RowEnumeration en = this.getReferenceTable().rowEnumeration();
        this.whole_table_is_simple_enum = en instanceof SimpleRowEnumeration;
        if (!this.whole_table_is_simple_enum) {
            this.whole_table_group = new IntegerVector(this.getReferenceTable().getRowCount());
            while (en.hasMoreRows()) {
                this.whole_table_group.addInt(en.nextRowIndex());
            }
        }
        this.group_resolver = new TableGroupResolver();
    }

    public void createGroupMatrix(Variable[] col_list) {
        if (this.getRowCount() <= 0 || col_list.length <= 0) {
            return;
        }
        Table root_table = this.getReferenceTable();
        int r_count = root_table.getRowCount();
        int[] col_lookup = new int[col_list.length];
        for (int i = col_list.length - 1; i >= 0; --i) {
            col_lookup[i] = root_table.findFieldName(col_list[i]);
        }
        IntegerVector row_list = root_table.orderedRowList(col_lookup);
        this.group_lookup = new IntegerVector(r_count);
        this.group_links = new IntegerVector(r_count);
        int current_group = 0;
        int previous_row = -1;
        for (int i = 0; i < r_count; ++i) {
            int row_index = row_list.intAt(i);
            if (previous_row != -1) {
                boolean equal = true;
                for (int n = 0; n < col_lookup.length && equal; ++n) {
                    TObject c1 = root_table.getCellContents(col_lookup[n], row_index);
                    TObject c2 = root_table.getCellContents(col_lookup[n], previous_row);
                    equal = equal && c1.compareTo(c2) == 0;
                }
                if (!equal) {
                    this.group_links.addInt(previous_row | 0x40000000);
                    current_group = this.group_links.size();
                } else {
                    this.group_links.addInt(previous_row);
                }
            }
            this.group_lookup.placeIntAt(current_group, row_index);
            previous_row = row_index;
        }
        this.group_links.addInt(previous_row | 0x40000000);
        this.group_resolver = new TableGroupResolver();
    }

    public Table getReferenceTable() {
        return this.cross_ref_table;
    }

    public int rowGroup(int row_index) {
        return this.group_lookup.intAt(row_index);
    }

    public int groupSize(int group_number) {
        int group_size = 1;
        int i = this.group_links.intAt(group_number);
        while ((i & 0x40000000) == 0) {
            ++group_size;
            i = this.group_links.intAt(++group_number);
        }
        return group_size;
    }

    public IntegerVector groupRows(int group_number) {
        IntegerVector ivec = new IntegerVector();
        int i = this.group_links.intAt(group_number);
        while ((i & 0x40000000) == 0) {
            ivec.addInt(i);
            i = this.group_links.intAt(++group_number);
        }
        ivec.addInt(i & 0x3FFFFFFF);
        return ivec;
    }

    public Table mergeWithReference(Variable max_column) {
        IntegerVector row_list;
        Table table = this.getReferenceTable();
        if (this.whole_table_as_group) {
            row_list = new IntegerVector(1);
            RowEnumeration row_enum = table.rowEnumeration();
            if (row_enum.hasMoreRows()) {
                row_list.addInt(row_enum.nextRowIndex());
            } else {
                row_list.addInt(0x7FFFFFFE);
            }
        } else if (table.getRowCount() == 0) {
            row_list = new IntegerVector(0);
        } else if (this.group_links != null) {
            if (max_column == null) {
                row_list = this.topFromEachGroup();
            } else {
                int col_num = this.getReferenceTable().findFieldName(max_column);
                row_list = this.maxFromEachGroup(col_num);
            }
        } else {
            int r_count = table.getRowCount();
            row_list = new IntegerVector(r_count);
            RowEnumeration en = table.rowEnumeration();
            while (en.hasMoreRows()) {
                row_list.addInt(en.nextRowIndex());
            }
        }
        Table[] tabs = new Table[]{table, this};
        IntegerVector[] row_sets = new IntegerVector[]{row_list, row_list};
        VirtualTable out_table = new VirtualTable(tabs);
        out_table.set(tabs, row_sets);
        if (DEBUG_QUERY && this.Debug().isInterestedIn(10)) {
            this.Debug().write(10, this, out_table + " = " + this + ".mergeWithReference(" + this.getReferenceTable() + ", " + max_column + " )");
        }
        table = out_table;
        return table;
    }

    IntegerVector topFromEachGroup() {
        IntegerVector extract_rows = new IntegerVector();
        int size = this.group_links.size();
        boolean take = true;
        for (int i = 0; i < size; ++i) {
            int r = this.group_links.intAt(i);
            if (take) {
                extract_rows.addInt(r & 0x3FFFFFFF);
            }
            take = (r & 0x40000000) != 0;
        }
        return extract_rows;
    }

    IntegerVector maxFromEachGroup(int col_num) {
        Table ref_tab = this.getReferenceTable();
        IntegerVector extract_rows = new IntegerVector();
        int size = this.group_links.size();
        int to_take_in_group = -1;
        TObject max = null;
        boolean take = true;
        for (int i = 0; i < size; ++i) {
            int r = this.group_links.intAt(i);
            int act_r_index = r & 0x3FFFFFFF;
            TObject cell = ref_tab.getCellContents(col_num, act_r_index);
            if (max == null || cell.compareTo(max) > 0) {
                max = cell;
                to_take_in_group = act_r_index;
            }
            if ((r & 0x40000000) == 0) continue;
            extract_rows.addInt(to_take_in_group);
            max = null;
        }
        return extract_rows;
    }

    public DataTableDef getDataTableDef() {
        return this.fun_table_def;
    }

    public TObject getCellContents(int column, int row) {
        DataCellCache cache = this.getDatabase().getDataCellCache();
        if (this.exp_info[column] == 0 && cache != null) {
            TObject cell = cache.get(this.unique_id, row, column);
            if (cell != null) {
                return cell;
            }
            cell = this.calcValue(column, row, cache);
            return cell;
        }
        return this.calcValue(column, row, null);
    }

    public RowEnumeration rowEnumeration() {
        return new SimpleRowEnumeration(this.row_count);
    }

    void addDataTableListener(DataTableListener listener) {
        this.getReferenceTable().addDataTableListener(listener);
    }

    void removeDataTableListener(DataTableListener listener) {
        this.getReferenceTable().removeDataTableListener(listener);
    }

    public void lockRoot(int lock_key) {
        this.getReferenceTable().lockRoot(lock_key);
    }

    public void unlockRoot(int lock_key) {
        this.getReferenceTable().unlockRoot(lock_key);
    }

    public boolean hasRootsLocked() {
        return this.getReferenceTable().hasRootsLocked();
    }

    public static Table resultTable(DatabaseQueryContext context, Expression expression) {
        Expression[] exp = new Expression[]{expression};
        String[] names = new String[]{"result"};
        FunctionTable function_table = new FunctionTable(exp, names, context);
        SubsetColumnTable result = new SubsetColumnTable(function_table);
        int[] map = new int[]{0};
        Variable[] vars = new Variable[]{new Variable("result")};
        result.setColumnMap(map, vars);
        return result;
    }

    public static Table resultTable(DatabaseQueryContext context, TObject ob) {
        Expression result_exp = new Expression();
        result_exp.addElement(ob);
        return FunctionTable.resultTable(context, result_exp);
    }

    public static Table resultTable(DatabaseQueryContext context, Object ob) {
        return FunctionTable.resultTable(context, TObject.objectVal(ob));
    }

    public static Table resultTable(DatabaseQueryContext context, int result_val) {
        return FunctionTable.resultTable(context, BigNumber.fromInt(result_val));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    final class TableGroupResolver
    implements GroupResolver {
        private IntegerVector group;
        private int group_number = -1;
        private TableGVResolver tgv_resolver;

        TableGroupResolver() {
        }

        private TableGVResolver createVariableResolver() {
            if (this.tgv_resolver != null) {
                return this.tgv_resolver;
            }
            this.tgv_resolver = new TableGVResolver();
            return this.tgv_resolver;
        }

        private void ensureGroup() {
            if (this.group == null) {
                this.group = this.group_number == -2 ? FunctionTable.this.whole_table_group : FunctionTable.this.groupRows(this.group_number);
            }
        }

        public void setUpGroupForRow(int row_index) {
            if (FunctionTable.this.whole_table_as_group) {
                if (this.group_number != -2) {
                    this.group_number = -2;
                    this.group = null;
                }
            } else {
                int g = FunctionTable.this.rowGroup(row_index);
                if (g != this.group_number) {
                    this.group_number = g;
                    this.group = null;
                }
            }
        }

        public int groupID() {
            return this.group_number;
        }

        public int size() {
            if (this.group_number == -2) {
                return FunctionTable.this.whole_table_group_size;
            }
            if (this.group != null) {
                return this.group.size();
            }
            return FunctionTable.this.groupSize(this.group_number);
        }

        public TObject resolve(Variable variable, int set_index) {
            int col_index = FunctionTable.this.getReferenceTable().fastFindFieldName(variable);
            if (col_index == -1) {
                throw new Error("Can't find column: " + variable);
            }
            this.ensureGroup();
            int row_index = set_index;
            if (this.group != null) {
                row_index = this.group.intAt(set_index);
            }
            TObject cell = FunctionTable.this.getReferenceTable().getCellContents(col_index, row_index);
            return cell;
        }

        public VariableResolver getVariableResolver(int set_index) {
            TableGVResolver resolver = this.createVariableResolver();
            resolver.setIndex(set_index);
            return resolver;
        }

        private class TableGVResolver
        implements VariableResolver {
            private int set_index;

            private TableGVResolver() {
            }

            void setIndex(int set_index) {
                this.set_index = set_index;
            }

            public int setID() {
                throw new Error("setID not implemented here...");
            }

            public TObject resolve(Variable variable) {
                return TableGroupResolver.this.resolve(variable, this.set_index);
            }

            public TType returnTType(Variable variable) {
                int col_index = FunctionTable.this.getReferenceTable().fastFindFieldName(variable);
                if (col_index == -1) {
                    throw new Error("Can't find column: " + variable);
                }
                return FunctionTable.this.getReferenceTable().getDataTableDef().columnAt(col_index).getTType();
            }
        }
    }
}

